# Database Languages
Database languages, also known as query languages or data query languages, are a classification of programming languages that developers use to define and access databases, which are collections of organized data that users can access electronically. These languages allow users to complete tasks such as controlling access to data, defining and updating data and searching for information within the database management system.

## 4 categories of database languages
Here are four types of database languages and their uses:

1. Data definition language (DDL)
Data definition language (DDL) creates the framework of the database by specifying the database schema, which is the structure that represents the organization of data. Its common uses include the creation and alteration of tables, files, indexes and columns within the database. This language also allows users to rename or drop the existing database or its components. Here's a list of DDL statements:
CREATE: Creates a new database or object, such as a table, index or column
ALTER: Changes the structure of the database or object
DROP: Deletes the database or existing objects
RENAME: Renames the database or existing objects

2. Data manipulation language (DML)
Data manipulation language (DML) provides operations that handle user requests, offering a way to access and manipulate the data that users store within a database. Its common functions include inserting, updating and retrieving data from the database. Here's a list of DML statements:
INSERT: Adds new data to the existing database table
UPDATE: Changes or updates values in the table
DELETE: Removes records or rows from the table
SELECT: Retrieves data from the table or multiple tables

3. Data control language (DCL)
Data control language (DCL) controls access to the data that users store within a database. Essentially, this language controls the rights and permissions of the database system. It allows users to grant or revoke privileges to the database. Here's a list of DCL statements:
GRANT: Gives a user access to the database
REVOKE: Removes a user's access to the database

4. Transaction control language (TCL)
Transaction control language (TCL) manages the transactions within a database. Transactions group a set of related tasks into a single, executable task. All the tasks must succeed in order for the transaction to work. Here's a list of TCL statements:
COMMIT: Carries out a transaction
ROLLBACK: Restores a transaction if any tasks fail to execute

# Few Examples of database languages
1. SQL
2. SQL/XML
3. GraphQL
